
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1117.C - Message 1117 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1117 messages.
//
//
//   REVISION HISTORY
//
//	  $Log:   V:\Projects\Labmon\Source\Archives\MSG1117.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:47:50   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.2   Jul 09 1997 09:58:22   COLEJ
//   Multiple Changes...
//   
//      Rev 1.0   25 Feb 1997 15:10:46   wladmin
//   Initial checking
//
////////////////////////////////////////////////////////////////////////////////

#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"   
#include "stdio.h" 


void wait(float);  
void clear_message_line(void);   

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1117 message from the ZMsgBuf.
//
void Dec1117(tMSGBUF *ZMsgBuf, tMSG1117 *Msg)
{  
   GetShort  (&Msg->SequenceNumber     , ZMsgBuf,  8); 
   GetUShort (&Msg->DutyCycle          , ZMsgBuf,  9);
}                                      


////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1117 message from the ZMsgBuf.
//
void Show1117(tMSG1117 *Msg)
{
   char    Buf[100] = "";

   sprintf(Buf,"%3d%%",  Msg->DutyCycle); 

   ShowText(Buf,PRTR+2   ,PRTC+6   );  
   wait(.5f);
}                                                 
                                      
 
